unit Fx101frm;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, ImageFX;

type
  TForm1 = class(TForm)
		Panel3: TPanel;
		BitBtn2: TBitBtn;
		Panel2: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    DelayScroller: TScrollBar;
    RateScroller: TScrollBar;
    Label3: TLabel;
    Label4: TLabel;
    Panel1: TPanel;
    ImageFX1: TImageFX;
		procedure FormResize(Sender: TObject);
		procedure BitBtn1Click(Sender: TObject);
    procedure DelayScrollerChange(Sender: TObject);
    procedure RateScrollerChange(Sender: TObject);
		procedure ImageFX1Complete(Sender: TObject);
	private
		procedure WaitForEffect;
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;

implementation

uses AbtImgFX;

{$R *.DFM}

procedure TForm1.FormResize(Sender: TObject);
const EffectType: string = ' Effect: ';
begin
	if ImageFX1.Busy then		{Run-time read only property to indicate when an effect is being processed}
		exit;									{This prevents stack overflow from doing multiple effects at once...a nasty GPF!}

	ImageFX1.EffectDelay := DelayScroller.Position;
	ImageFX1.EffectRate := RateScroller.Position;

	Label3.Caption := IntToStr(DelayScroller.Position);
	Label4.Caption := IntToStr(RateScroller.Position);

	ImageFX1.LoadFromFile('earth.bmp');
	ImageFX1.Effect := ViewExplode;
	Panel3.Caption := EffectType + 'ViewExplode';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := ViewZoomIn;
	Panel3.Caption := EffectType + 'ViewZoomIn';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := ViewZoomOut;
	Panel3.Caption := EffectType + 'ViewZoomOut';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('skyline.bmp');
	ImageFX1.Effect := HideImplode;
	Panel3.Caption := EffectType + 'HideImplode';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := HideZoomIn;
	Panel3.Caption := EffectType + 'HideZoomIn';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := HideZoomOut;
	Panel3.Caption := EffectType + 'HideZoomOut';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('earth.bmp');
	ImageFX1.Effect := WipeRightRoll;
	Panel3.Caption := EffectType + 'WipeRightRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeRightSlide;
	Panel3.Caption := EffectType + 'WipeRightSlide';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeRightStretch;
	Panel3.Caption := EffectType + 'WipeRightStretch';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('skyline.bmp');
	ImageFX1.Effect := WipeLeftRoll;
	Panel3.Caption := EffectType + 'WipeLeftRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeLeftSlide;
	Panel3.Caption := EffectType + 'WipeLeftSlide';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeLeftStretch;
	Panel3.Caption := EffectType + 'WipeLeftStretch';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('earth.bmp');
	ImageFX1.Effect := WipeUpRoll;
	Panel3.Caption := EffectType + 'WipeUpRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeUpSlide;
	Panel3.Caption := EffectType + 'WipeUpSlide';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeUpStretch;
	Panel3.Caption := EffectType + 'WipeUpStretch';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('skyline.bmp');
	ImageFX1.Effect := WipeDownRoll;
	Panel3.Caption := EffectType + 'WipeDownRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeDownSlide;
	Panel3.Caption := EffectType + 'WipeDownSlide';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := WipeDownStretch;
	Panel3.Caption := EffectType + 'WipeDownStretch';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('earth.bmp');
	ImageFX1.Effect := SideCurtainRoll;
	Panel3.Caption := EffectType + 'SideCurtainRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('skyline.bmp');
	ImageFX1.Effect := VertCurtainRoll;
	Panel3.Caption := EffectType + 'VertCurtainRoll';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.Effect := HideZoomOut;
	Panel3.Caption := EffectType + 'HideZoomOut';
	ImageFX1.ShowEffect;
	WaitForEffect;

	ImageFX1.LoadFromFile('skyline.bmp');
	ImageFX1.Effect := None;
	Panel3.Caption := EffectType + 'None';
	ImageFX1.ShowEffect;
	WaitForEffect;
end;

{A loop to allow current wipe to finish and change effect rate and delay during draw}
procedure TForm1.WaitForEffect;
begin
	BitBtn1.Enabled := False;
	while ImageFX1.Busy do
	begin
		Application.ProcessMessages;
		ImageFX1.EffectDelay := DelayScroller.Position;
		ImageFX1.EffectRate := RateScroller.Position;

		Label3.Caption := IntToStr(DelayScroller.Position);
		Label4.Caption := IntToStr(RateScroller.Position);
	end;
	BitBtn1.Enabled := True;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
	AboutBox.Show;
end;

procedure TForm1.DelayScrollerChange(Sender: TObject);
begin
	Label3.Caption := IntToStr(DelayScroller.Position);
end;

procedure TForm1.RateScrollerChange(Sender: TObject);
begin
	Label4.Caption := IntToStr(RateScroller.Position);
end;

procedure TForm1.ImageFX1Complete(Sender: TObject);
begin
	ShowMessage(Panel3.Caption + ' is complete');
end;

initialization
end.
